<?php
/*--------------------------------------------------------------
   Timespan.php 2021-08-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects;

use DateTimeImmutable;
use Webmozart\Assert\Assert;

class Timespan
{
    /**
     * @var DateTimeImmutable $start
     */
    private $start;
    
    /**
     * @var DateTimeImmutable $end
     */
    private $end;
    
    
    /**
     * Constructor.
     */
    private function __construct(DateTimeImmutable $start, DateTimeImmutable $end)
    {
        $this->start = $start;
        $this->end   = $end;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(DateTimeImmutable $start, DateTimeImmutable $end): self
    {
        Assert::lessThan($start, $end);
        
        return new self($start, $end);
    }
    
    
    /**
     * Return start date.
     */
    public function startDate(): DateTimeImmutable
    {
        return $this->start;
    }
    
    
    /**
     * Return end date.
     */
    public function endDate(): DateTimeImmutable
    {
        return $this->end;
    }
    
}